/*
 * Decompiled with CFR 0.152.
 */
package com.xhaus.modjy;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.Enumeration;
import java.util.Properties;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.python.core.Py;
import org.python.core.PyException;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PySystemState;
import org.python.core.PyType;
import org.python.core.imp;
import org.python.util.PythonInterpreter;

public class ModjyJServlet
extends HttpServlet {
    protected static final String MODJY_PYTHON_CLASSNAME = "modjy_servlet";
    protected static final String LIB_PYTHON = "/WEB-INF/lib-python";
    protected static final String PTH_FILE_EXTENSION = ".pth";
    protected static final String LOAD_SITE_PACKAGES_PARAM = "load_site_packages";
    protected static final String PYTHON_HOME_PARAM = "python.home";
    protected PythonInterpreter interp;
    protected HttpServlet modjyServlet;

    protected Properties readConfiguration() {
        String string;
        Properties properties = new Properties();
        ServletContext servletContext = this.getServletContext();
        Enumeration enumeration = servletContext.getInitParameterNames();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            properties.put(string, servletContext.getInitParameter(string));
        }
        enumeration = this.getInitParameterNames();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            properties.put(string, this.getInitParameter(string));
        }
        string = properties.getProperty(PYTHON_HOME_PARAM);
        if (string != null) {
            File file = new File(string);
            if (!file.isAbsolute()) {
                string = servletContext.getRealPath(string);
            }
            properties.setProperty(PYTHON_HOME_PARAM, string);
        }
        return properties;
    }

    public void init() throws ServletException {
        try {
            Properties properties = this.readConfiguration();
            PythonInterpreter.initialize(System.getProperties(), properties, new String[0]);
            PySystemState pySystemState = new PySystemState();
            this.interp = new PythonInterpreter(null, pySystemState);
            this.setupEnvironment(this.interp, properties, pySystemState);
            try {
                this.interp.exec("from modjy.modjy import modjy_servlet");
            }
            catch (PyException pyException) {
                throw new ServletException("Unable to import 'modjy_servlet': maybe you need to set the 'python.home' parameter?", (Throwable)pyException);
            }
            PyObject pyObject = ((PyType)this.interp.get(MODJY_PYTHON_CLASSNAME)).__call__();
            Object object = pyObject.__tojava__(HttpServlet.class);
            if (object == Py.NoConversion) {
                throw new ServletException("Corrupted modjy file: cannot find definition of 'modjy_servlet' class");
            }
            this.modjyServlet = (HttpServlet)object;
            this.modjyServlet.init((ServletConfig)this);
        }
        catch (PyException pyException) {
            throw new ServletException("Exception creating modjy servlet: " + pyException.toString(), (Throwable)pyException);
        }
    }

    public void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.modjyServlet.service((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
    }

    public void destroy() {
        this.interp.cleanup();
    }

    protected void setupEnvironment(PythonInterpreter pythonInterpreter, Properties properties, PySystemState pySystemState) throws PyException {
        this.processPythonLib(pythonInterpreter, pySystemState);
        this.checkSitePackages(properties);
    }

    protected void checkSitePackages(Properties properties) throws PyException {
        String string = properties.getProperty(LOAD_SITE_PACKAGES_PARAM);
        boolean bl = true;
        if (string != null && string.trim().compareTo("0") == 0) {
            bl = false;
        }
        if (bl) {
            imp.load("site");
        }
    }

    protected void processPythonLib(PythonInterpreter pythonInterpreter, PySystemState pySystemState) {
        String[] stringArray;
        String string = this.getServletContext().getRealPath(LIB_PYTHON);
        if (string == null) {
            return;
        }
        File file = new File(string);
        if (!file.exists()) {
            return;
        }
        pySystemState.path.append(new PyString(string));
        for (String string2 : stringArray = file.list()) {
            if (!string2.endsWith(PTH_FILE_EXTENSION)) continue;
            this.processPthFile(pythonInterpreter, pySystemState, string, string2);
        }
    }

    protected void processPthFile(PythonInterpreter pythonInterpreter, PySystemState pySystemState, String string, String string2) {
        try {
            String string3;
            LineNumberReader lineNumberReader = new LineNumberReader(new FileReader(new File(string, string2)));
            while ((string3 = lineNumberReader.readLine()) != null) {
                if ((string3 = string3.trim()).length() == 0 || string3.startsWith("#")) continue;
                if (string3.startsWith("import")) {
                    pythonInterpreter.exec(string3);
                    continue;
                }
                File file = new File(string, string3);
                String string4 = file.getAbsolutePath();
                pySystemState.path.append(new PyString(string4));
            }
        }
        catch (IOException iOException) {
            System.err.println("IOException: " + iOException.toString());
        }
    }
}

